//
// Copyright (C) 2017  Secret
//
// This script is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

function IgnoreAccountArgument()
{
    var offset = pe.stringVa("/account:");
    if (offset === -1)
    {
        return "Failed in Step 1 - /account: not found.";
    }

    var code = " 68" + offset.packToHex(4);
    offset = pe.findCode(code);
    if (offset === -1)
    {
        return "Failed in Step 1 - Reference not found.";
    }

    code =

        " 83 C4 08"    +
        " 85 C0"    +
        " 74 ??";
    offset = pe.find(code, offset, offset + 0x20);
    if (offset === -1)
    {
        return "Failed in Step 2 - Comparison not found.";
    }

    offset += 5;

    pe.replaceByte(offset, 0xEB);

    return true;
}
